/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.planning;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.pfa.GraphPath;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import java.util.List;
import technology.rocketjump.undermount.entities.planning.JobAccessibilityCallback;
import technology.rocketjump.undermount.entities.planning.PathfindingCallback;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.messaging.types.JobAccessibilityRequestMessage;
import technology.rocketjump.undermount.messaging.types.PathfindingRequestMessage;
import technology.rocketjump.undermount.misc.VectorUtils;

public class JobAccessibilityTask
implements Runnable,
PathfindingCallback {
    private static final long TIME_TO_WITH_MILLIS = 5000L;
    private final Job job;
    private final Vector2 assignableEntityLocation;
    private final MessageDispatcher messageDispatcher;
    private final List<GridPoint2> potentialLocations;
    private final JobAccessibilityCallback callback;
    private final TiledMap areaMap;
    private GraphPath<Vector2> pathFound;

    public JobAccessibilityTask(JobAccessibilityRequestMessage message, MessageDispatcher messageDispatcher) {
        this.areaMap = message.getMap();
        this.job = message.getJob();
        this.potentialLocations = message.getPotentialLocations();
        this.callback = message.getCallback();
        this.assignableEntityLocation = message.getAssignableEntityLocation();
        this.messageDispatcher = messageDispatcher;
    }

    @Override
    public void run() {
        while (!this.potentialLocations.isEmpty()) {
            GridPoint2 locationToTry = this.potentialLocations.remove(0);
            PathfindingRequestMessage pathfindingRequestMessage = new PathfindingRequestMessage(this.assignableEntityLocation, VectorUtils.toVector(locationToTry), this.areaMap, this, this.job.getJobId());
            this.messageDispatcher.dispatchMessage(400, pathfindingRequestMessage);
            long startTime = System.currentTimeMillis();
            while (this.pathFound == null) {
                try {
                    Thread.sleep(100L);
                    if (System.currentTimeMillis() - startTime <= 5000L) continue;
                    break;
                }
                catch (InterruptedException e) {
                    System.err.println("Error in " + this.getClass().getSimpleName() + ": " + e.getMessage());
                    this.callback.onComplete(this.job, false);
                    return;
                }
            }
            if (this.pathFound == null || this.pathFound.getCount() == 0) continue;
            this.callback.onComplete(this.job, true);
            return;
        }
        this.callback.onComplete(this.job, false);
    }

    @Override
    public void pathfindingComplete(GraphPath<Vector2> path, long relatedId) {
        this.pathFound = path;
    }
}

